function [ package_up_channel ] = upconvert_package_to_passband( package, pulse, fs, f0, R )
%upconvert a package from baseband to passband
%   Detailed explanation goes here

% % This determines how many times one symbol is repeated in a row (so it
% % depends on T which is determined in the config section on top of this
% % script.) This is NOT pulse shaping
% symbol_repetition = ones(1,T);
% 
% % Upsample the signal in baseband such that each symbol is repeated T
% % times. This upsampling operation will insert zeros in the first place, 
% % after that it will filter with the specified filter (which will just copy
% % the symbols if the filter containes only ones)
% tx = upfirdn(channel_input, symbol_repetition, T, 1);

if isempty(package)
    return;
end

% We have a sampling frequency fs=44100 and a carrier frequency of f0=fs/k
Ts = 1/fs;          % duration of one sample
T0 = 1/f0;          % duration of one period in the passband
Tr = 1/R;           % duration of one symbol in the passband
k = Tr/Ts;    % samples per symbol in passband


% upsample now to passband such that number of samples is correct (before,
% we only had symbols. These symbols will be transmitted as k samples per
% symbol. Therefore, extend the symbol vector to a vector of samples)
package_up_real = upfirdn(real(package), pulse, k, 1);
package_up_imag = upfirdn(imag(package), pulse, k, 1);

% In order to shift from baseband to passband, we multiply the real part of
% the symbols to be transmitted with a cosine and the imaginary part to be
% transmitted with a sine. That way, they are orthogonal.

% create time axis
t_signal = Ts:Ts:length(package_up_real)*Ts;

% create cos and sin for the specified time axis
cos_shape = sqrt(2)*cos(2*pi*f0*t_signal);
sin_shape = -sqrt(2)*sin(2*pi*f0*t_signal);

% multiply the symbols to be transmitted with the cos and sine
package_up_sc = cos_shape .* package_up_real;
package_up_ss = sin_shape .* package_up_imag;

% signal upsampled to passband
package_up_channel = package_up_sc + package_up_ss;

end

